<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" encoding="UTF-8" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.CIP4.org/JDFSchema_1_1" xmlns:cal="http://www.caldera.com/jdf">

<xsl:template match="/">

<xsl:variable name="ORDER" select="/Job/ORDER/text()"/>


  <JDF JobPartID="1" Status="Waiting" Activation="Active" Type="DigitalPrinting" Version="1.4" ICSVersions="Base_L1-1.4" >

                 <xsl:attribute name="ID"><xsl:value-of select="/Job/ID/text()"/></xsl:attribute>
                 <xsl:attribute name="JobID"><xsl:value-of select="/Job/JOBID/text()"/></xsl:attribute>
                 <xsl:attribute name="DescriptiveName"><xsl:value-of select="/Job/JOBDESCR/text()"/></xsl:attribute>

<Comment Name="JobDescription">
 		<xsl:value-of select="/Job/ORDER/text()"/>
</Comment>


  <ResourcePool>
    <RunList Class="Parameter" ID="RL001" Status="Available"  >
        <xsl:attribute name="DocCopies"><xsl:value-of select="/Job/COPIES/text()"/></xsl:attribute>
    
      <LayoutElement>
		<FileSpec>
            <xsl:attribute name="URL">file://<xsl:value-of select="/Job/FILE/text()"/></xsl:attribute>
			
		</FileSpec>
 
 	</LayoutElement>
    </RunList>
    
    <DigitalPrintingParams Class="Parameter" ID="DPP001" Status="Available">

    </DigitalPrintingParams>
 
    <CustomerInfo Class="Parameter" ID="CI001" Status="Available" CustomerID="ORDER001"  >
        <xsl:attribute name="CustomerOrderID"><xsl:value-of select="/Job/ORDER/text()"/></xsl:attribute>
     <Contact ContactTypes="Sales">
        <Company>
                <xsl:attribute name="OrganizationName"><xsl:value-of select="/Job/CUSTOMER/text()"/></xsl:attribute>
         </Company>
     </Contact>
    </CustomerInfo>


    <Device Class="Implementation" ID="DEV001" Status="Available">
        <xsl:attribute name="DeviceID"><xsl:value-of select="/Job/PRINTER/text()"/></xsl:attribute>

    </Device> 

    <Component Class="Quantity" ID="C001" Status="Unavailable" ComponentType="FinalProduct" />

  </ResourcePool>

  <ResourceLinkPool>
    <DigitalPrintingParamsLink Usage="Input" rRef="DPP001" />
    <RunListLink Usage="Input" rRef="RL001" />
    <CustomerInfoLink Usage="Input" rRef="CI001" />
    <DeviceLink Usage="Input" rRef="DEV001" />
    <ComponentLink Usage="Output" rRef="C001" />
  </ResourceLinkPool>

  <AuditPool>
    <Created AgentName="Caldera JDF" AgentVersion="10.0" TimeStamp="2015-06-18T09:33:18+02:00" />
  </AuditPool>
  
</JDF>

</xsl:template>
</xsl:stylesheet>


